/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rooms.constructions;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.behaviour.ItemBehaviour;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.QuantifiedItemType;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.gamecontext.Updatable;
import technology.rocketjump.undermount.jobs.JobWorkCalculator;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.JobState;
import technology.rocketjump.undermount.jobs.model.JobType;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.rooms.ItemAllocation;
import technology.rocketjump.undermount.rooms.constructions.Construction;
import technology.rocketjump.undermount.rooms.constructions.ConstructionStore;
import technology.rocketjump.undermount.rooms.constructions.FurnitureConstruction;
import technology.rocketjump.undermount.settlement.ItemTracker;

@Singleton
public class ConstructionUpdater
implements GameContextAware,
Updatable {
    private final ConstructionStore constructionStore;
    private final ItemTracker itemTracker;
    private final MessageDispatcher messageDispatcher;
    private final JobWorkCalculator jobWorkCalculator;
    private GameContext gameContext;

    @Inject
    public ConstructionUpdater(ConstructionStore constructionStore, ItemTracker itemTracker, MessageDispatcher messageDispatcher, JobWorkCalculator jobWorkCalculator) {
        this.constructionStore = constructionStore;
        this.itemTracker = itemTracker;
        this.messageDispatcher = messageDispatcher;
        this.jobWorkCalculator = jobWorkCalculator;
    }

    @Override
    public void update(float deltaTime) {
        Construction construction = this.constructionStore.next();
        if (construction != null && construction instanceof FurnitureConstruction) {
            this.update((FurnitureConstruction)construction);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void update(FurnitureConstruction furnitureConstruction) {
        FurnitureEntityAttributes attributes = (FurnitureEntityAttributes)furnitureConstruction.getEntity().getPhysicalEntityComponent().getAttributes();
        if (furnitureConstruction.getConstructionJob() == null) {
            for (QuantifiedItemType quantifiedItemType : furnitureConstruction.getRequirements()) {
                int amountRequired = quantifiedItemType.getQuantity();
                for (ItemAllocation itemAllocation : furnitureConstruction.getAllocatedItems()) {
                    if (!itemAllocation.getItemType().equals(quantifiedItemType.getItemType())) continue;
                    amountRequired -= itemAllocation.getQuantity();
                }
                if (amountRequired <= 0) continue;
                Job haulingJobForNewAllocation = this.createNewItemAllocation(furnitureConstruction, quantifiedItemType, amountRequired);
                if (haulingJobForNewAllocation != null) {
                    this.messageDispatcher.dispatchMessage(null, 609, (Object)haulingJobForNewAllocation);
                }
                return;
            }
            boolean allRequirementsMet = true;
            for (QuantifiedItemType requirement : furnitureConstruction.getRequirements()) {
                boolean thisRequirementMet = false;
                int quantityInPlace = 0;
                for (GridPoint2 tileLocation : furnitureConstruction.getTileLocations()) {
                    MapTile tileAtLocation = this.gameContext.getAreaMap().getTile(tileLocation);
                    for (Entity entity : tileAtLocation.getEntities()) {
                        ItemEntityAttributes itemAttributes;
                        if (!entity.getType().equals((Object)EntityType.ITEM) || !(itemAttributes = (ItemEntityAttributes)entity.getPhysicalEntityComponent().getAttributes()).getItemType().equals(requirement.getItemType()) || (quantityInPlace += itemAttributes.getQuantity()) < requirement.getQuantity()) continue;
                        thisRequirementMet = true;
                        break;
                    }
                    if (!thisRequirementMet) continue;
                    break;
                }
                if (thisRequirementMet) continue;
                allRequirementsMet = false;
                break;
            }
            if (allRequirementsMet) {
                void var4_9;
                JobType jobType = JobType.CONSTRUCT_WOODEN_FURNITURE;
                if (attributes.getPrimaryMaterialType().equals((Object)GameMaterialType.STONE)) {
                    JobType jobType2 = JobType.CONSTRUCT_STONE_FURNITURE;
                }
                Job constructionJob = new Job((JobType)var4_9);
                constructionJob.setJobLocation(furnitureConstruction.getPrimaryLocation());
                constructionJob.setTotalWorkToDo(this.jobWorkCalculator.getTotalWorkToDo(furnitureConstruction));
                constructionJob.setWorkDoneSoFar(0.0f);
                constructionJob.setJobState(JobState.POTENTIALLY_ACCESSIBLE);
                furnitureConstruction.setConstructionJob(constructionJob);
                this.messageDispatcher.dispatchMessage(609, constructionJob);
            }
        }
    }

    private Job createNewItemAllocation(FurnitureConstruction furnitureConstruction, QuantifiedItemType requirement, int amountRequired) {
        Vector2 constructionLocation = furnitureConstruction.getEntity().getLocationComponent().getWorldPosition();
        List<Entity> items = this.itemTracker.getItemsByType(requirement.getItemType(), true);
        if (items != null) {
            Collections.sort(items, (o1, o2) -> (int)(1000.0f * (constructionLocation.dst2(o1.getLocationComponent().getWorldPosition()) - constructionLocation.dst2(o2.getLocationComponent().getWorldPosition()))));
            Iterator<Entity> iterator = items.iterator();
            if (iterator.hasNext()) {
                Entity itemEntity = iterator.next();
                ItemEntityAttributes itemAttributes = (ItemEntityAttributes)itemEntity.getPhysicalEntityComponent().getAttributes();
                int numToAllocate = Math.min(itemAttributes.getItemType().getMaxHauledAtOnce(), Math.min(amountRequired, itemAttributes.getNumUnallocated()));
                ItemAllocation allocation = new ItemAllocation();
                allocation.setTargetType(ItemAllocation.AllocationTargetType.CONSTRUCTION);
                allocation.setTargetId(furnitureConstruction.getId());
                allocation.setItemEntityId(itemEntity.getId());
                allocation.setItemType(itemAttributes.getItemType());
                allocation.setGameMaterial(itemAttributes.getMaterial(itemAttributes.getItemType().getPrimaryMaterialType()));
                allocation.setQuantity(numToAllocate);
                GridPoint2 targetPosition = this.getTargetPositionForAllocation(allocation, furnitureConstruction);
                allocation.setTargetPosition(targetPosition);
                itemAttributes.setNumAllocated(itemAttributes.getNumAllocated() + numToAllocate);
                furnitureConstruction.getAllocatedItems().add(allocation);
                return ItemBehaviour.createHaulingJob(this.gameContext.getAreaMap().getTile(itemEntity.getLocationComponent().getWorldPosition()), allocation, itemEntity);
            }
        }
        return null;
    }

    private GridPoint2 getTargetPositionForAllocation(ItemAllocation allocation, FurnitureConstruction furnitureConstruction) {
        ArrayList<GridPoint2> positionsToCheck = new ArrayList<GridPoint2>();
        positionsToCheck.add(furnitureConstruction.getPrimaryLocation());
        for (GridPoint2 location : furnitureConstruction.getTileLocations()) {
            if (location.equals(furnitureConstruction.getPrimaryLocation())) continue;
            positionsToCheck.add(location);
        }
        for (GridPoint2 positionToCheck : positionsToCheck) {
            ItemAllocation existingAllocation = this.getExistingAllocation(positionToCheck, furnitureConstruction);
            if (existingAllocation == null) {
                return positionToCheck;
            }
            if (!existingAllocation.getGameMaterial().equals(allocation.getGameMaterial())) continue;
            return positionToCheck;
        }
        return furnitureConstruction.getPrimaryLocation();
    }

    private ItemAllocation getExistingAllocation(GridPoint2 positionToCheck, FurnitureConstruction furnitureConstruction) {
        for (ItemAllocation itemAllocation : furnitureConstruction.getAllocatedItems()) {
            if (!itemAllocation.getTargetPosition().equals(positionToCheck)) continue;
            return itemAllocation;
        }
        return null;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }
}

